/*            FOURIER SPECTRA           */
/*              __________              */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#define PI  3.14159
#define TRUE  1
#define FALSE 0

typedef struct {
float x;
float y;
} Z;


Z parseimage(char *s)
{
/* If there are two data items on a line then the second is the */
/* time series. If there is only one on a line, it must be the  */
/* time series/ */
int i=0,j=0,element=0,readingnumber=FALSE;
float x[3];    /* one extra in case */
char buf[31];
Z z;
while (element<2)
{
   switch (*(s+i)) {
   case '0':
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
   case '+':
   case 'e':
   case '-':
   case '.':
      readingnumber=TRUE;
      buf[j]=*(s+i);
      j++;
      break;
   case ' ':
   case ',':
   if (readingnumber)
   {
      buf[j]=(char)0;
      x[element]=atof(buf);
      element++;
      readingnumber=FALSE;
      j=0;
   }
   break;
   case '\n':
   if (readingnumber)
   {
      buf[j]=(char)0;
      x[element]=atof(buf);
      element++;
      readingnumber=FALSE;
      j=0;
   }
   if (element>1) { z.x=x[0]; z.y=x[1];}
   else if (element==1) { z.x=x[0]; z.y=0.0;}
   return(z);
   default: break;
   } /* end switch */
     i++;
}
/* oops! */
printf("Found a badly formatted line of input.\n");
exit(1);
}

main(int argc, char **argv)
{
FILE *in,*out;
char str[81];
float huge *height;
int i,j,key,forward,count=4096,type=0,values[2];
Z z;
/* process command line */
/* open input file */
    if (argc<5)  /* not enough  arguments in command line */
    {
       printf("Error. Not enough parameters passed to routine.\n");
       printf("Use this program by typing the command line:\n\n");
       printf("SPECTRUM INPUT OUTPUT COUNT TYPE\n\n");
       printf("Where SPECTRUM is the name of this program, and\n");
       printf("INPUT is the name of a file which contains COUNT\n");
       printf("amplitudes in %%f or %%f %%f format. Integer TYPE=0 if the\n");
       printf("amplitudes are all real in %%f format. TYPE=1 if the\n");
       printf("amplitudes are complex (real, imaginary) in %%f %%f format.\n");
       printf("If TYPE=-1 input is a complex series for reverse FFT.\n");
       printf("OUTPUT is the name of a file to contain the processed\n");
       printf("spectrum with real and imaginary parts interleaved.\n\n");
       exit(1);
    }
    else if ((in=fopen(*++argv, "r")) == NULL)
    {
       printf("Input file not found.\n");
       exit(1);
    }
    if ((out=fopen(*++argv, "r")) == NULL)
       out=fopen(*argv,"w");
    else
    {
       printf("Destination file %s already exists.\n",*argv);
       printf("Shall I overwrite it (y/n)?");
       key=toupper(bioskey(0));
       if (key=='Y')
       {
	  printf(" Yes\n");
	  out=fopen(*argv,"w");
       }
       else
       {
	  printf(" No\n");
	  exit(1);
       }
    }
    count=atoi(*++argv);
    if (count>4096)
    {
       printf("Count is too large. It is greater than 4096.\n");
       exit(1);
    }
    if (count%2!=0)
    {
       printf("You have specified a odd number of values in the series.\n");
       printf("This will take a long time to calculate. It is not an FFT any longer.\n");
    }
    type=atoi(*++argv);
    if (type!=1 && type!=0 && type!=-1)
    {
       printf("Type must be real (TYPE=0) or complex (TYPE=1) or reverse (TYPE=-1).\n");
       exit(0);
    }
    if (type==-1)
    { type=1; forward=FALSE; }
    else
    forward=TRUE;

/* get memory for data */
height = (float huge *)calloc(2*4096,sizeof(float));
if (height==NULL)
{
   printf("Insufficient memory to allocate. Make COUNT a smaller number\n");
   exit(1);
}
/* read and parse data */

i=0;
while (  (fgets( str, 80, in)!=NULL) && (i<count) )
{
 j=2*i;
 z = parseimage(str);
 height[j] = z.x;
 height[j+1] = z.y;
 i++;
}  /* READING WHILE LOOP */

values[0] = count = i;

if (type==1)
{
/* process forward with complex values contiguous */
if (forward) fourt( height, values, 1, -1,  1);
else fourt( height, values, 1, 1, 1);
}
else
/* process forward with real values */
fourt( height, values, 1, -1,  0);
for (i=0; i<2*count; i+=2)
{
if (forward) fprintf(out,"%10.4f %10.4f\n",height[i],height[i+1]);
else fprintf(out,"%10.4f %10.4f\n",height[i]/count,height[i+1]/count);
}

} /* end spectrum */