/* ---- routine to handle factors not equal to 2 in the fast Fourier
        transform.   k.t.kilty  1988. */
#define  TWOPI   6.28318531
#define  FACTORS 32
#include <math.h>
#include <alloc.h>

/* --- external elements --- internal to package --- */

extern  long  Np1,Np2,Ntwo,Total,Range;
extern  long  Factors[FACTORS],F,Nwork;

void   not_factors_of_2(float huge *a,int sign)
{
long  i,j,p,q,r,s,t,u,half_np1,p1,p2,qrange,conj;
long  jmin,jmax,pmin,qmin,qmax,smax,rmax,pmax,tmax;
float theta,temp_i,temp_r,w_i,w_r,sum_i,sum_r,wstp_i,wstp_r;
float olds_r,olds_i,twow_r=0.0,*work;
    work=(float*)calloc((unsigned)Nwork,sizeof(float));
    p1=Ntwo;
    half_np1=Np1/2;
    do    /* while p1<Np2 */
    {
       p2=p1*Factors[F];
       pmin=Np1;
       if(pmin<=p1)
       {
	  for(p=pmin; p<p1; p+=Np1)
	  {
	     theta=-TWOPI*(float)p/(float)p2;
	     if (sign==1) theta=-theta;
	     w_r=wstp_r=(float)cos((double)theta);
	     w_i=wstp_i=(float)sin((double)theta);
	     qmin=p+p1;
	     qmax=p+1+p2-p1;
	     for(q=qmin; q<qmax; q+=p1)
	     {
		smax=q+Range-1;
		for(s=q; s<smax; s+=2)
		{
		   for(r=s; r<Total; r+=p2)
		   {
		       temp_r=a[r];
		       a[r]=a[r]*w_r-a[r+1]*w_i;
		       a[r+1]=temp_r*w_i+a[r+1]*w_r;
		   }  /* loop over r */
		} /* loop over s */
		temp_r=w_r;
		w_r=w_r*wstp_r-w_i*wstp_i;
		w_i=temp_r*wstp_i+w_i*wstp_r;
	     } /* loop over q */
	  }    /* loop over p */
       } /* if pmin<=p1 */
       theta=-TWOPI/(float)Factors[F];
       if (sign==1) theta=-theta;
       wstp_r=(float)cos((double)theta);
       wstp_i=(float)sin((double)theta);
       qrange=p1*(1+Factors[F]/2);
       for(s=0; s<Range; s+=2)
       {
	  for(u=s; u<Total; u+=Np2)
	  {
	     qmax=u+1+qrange-p1;
	     for(q=u; q<qmax; q+=p1)
	     {
		pmax=q+1+p1-Np1;
		for(p=q; p<pmax; p+=Np1)
		{
		   rmax=p+1+Np2-p2;
		   for(r=p; r<rmax; r+=p2)
		   {
		      jmin=r-q+u;
		      jmax=jmin+1+p2-p1;
		      i=(r-u)/half_np1;
		      if (q<=u)
		      {
			 sum_r=sum_i=0.0;
			 for(j=jmin; j<jmax; j+=p1)
			 {
			    sum_r+=a[j];
			    sum_i+=a[j+1];
			 } /* loop over j */
			 work[i]=sum_r;
			 work[i+1]=sum_i;
		      } /* if q<=u */
		      else
		      {
			 conj=(p2+u+r-2*q)/half_np1;
			 sum_r=a[jmax-1];
			 sum_i=a[jmax];
			 olds_r=olds_i=0.0;
			 j=jmax-1-p1;
			 do /* while j>jmin */
			 {
			    temp_r=sum_r;
			    temp_i=sum_i;
			    sum_r=twow_r*sum_r-olds_r+a[j];
			    sum_i=twow_r*sum_i-olds_i+a[j+1];
			    olds_r=temp_r;
			    olds_i=temp_i;
			    j-=p1;
			 } while(j>jmin);
			 temp_r=w_r*sum_r-olds_r+a[j];
			 temp_i=w_i*sum_i;
			 work[i]=temp_r-temp_i;
			 work[conj]=temp_r+temp_i;
			 temp_r=w_r*sum_i-olds_i+a[j+1];
			 temp_i=w_i*sum_r;
			 work[i+1]=temp_r+temp_i;
			 work[conj+1]=temp_r-temp_i;
		      } /* if q>u */
		   } /* loop over r */
		} /* loop over p */
		if (q<=u)
		{
		   w_r=wstp_r;
		   w_i=wstp_i;
		} /* q<u */
	        else
		{
		   temp_r=w_r;
		   w_r=w_r*wstp_r-w_i*wstp_i;
		   w_i=temp_r*wstp_i+w_i*wstp_r;
		} /* q>u */
	        twow_r=2*w_r;
	     } /* loop over q */
             i=0;
	     tmax=u+1+Np2-Np1;
	     for(t=u; t<tmax; t+=Np1)
	     {
		a[t]=work[i];
		a[t+1]=work[i+1];
		i+=2;
	     } /* loop over t */
	  } /* loop over u */
       } /* loop over s */
       F++;
       p1=p2;
    } while(p1<Np2);
    free(work);
}   /* n_factor_of_2 */

