#define  FACTORS  32
#define  TWOPI    6.283185
#define  FALSE    0
#define  TRUE     1
#include <math.h>
#include <alloc.h>

/*    ----------------------------------------------
       Fast Fourier Transform Routine
      ----------------------------------------------

      Original algorithm by Norman Brenner and Charles
      Rader, June 1967.  'C' version by k.t.kilty October
      1988.  This is a zerobased index version.

      Module calling sequence is:

      fourt( array, values, dimensions, sign, complex)

      where  array=(float) array of data values to be transformed the
		     data begins in element 0.
	     values=(int) array of number of data values in
			 each dimension (zero based indexing).
	     dimensions=(int) number of dimensions.
	     sign=(int) sign of the Fourier transform...+1=inverse.
	     complex=(int) 1=complex data array with the real part in
			   even numbered elements and imaginary part in
			   the odd numbered elements. 0=real data with
			   actual data values in the even numbered elements.
			   -1=real data array with actual data in
			   contiguous storage locations.

      the routines named factor_integer, factors_of_2,not_factors_of_2,
      conj_symmetry_1st,conj_symmetry_2nd_3rd,power_of_2,not_power_of_2,
      must also be present.

           program separates problem into one of 4 cases
               1=complex transform for 4th,9th,16th...dimensions
               2=real transform for 2nd or 3rd dimensions
	       3=real transform for 1st dimension n=odd
	       4=real transform for 1st dimension n=even

                case 2 uses the method of transforming 1/2 the
		data and supplying the other 1/2 by conjugate
		symmetry.  case 3 is done by setting the imaginary
		parts to zero.  case 4 by transforming a complex
		array of length n/2 in which the real part is the
		even numbered elements of data and the imaginary
		part is the odd numbered elements.
      -------------------------------------------------------- */
/* --- elements external to modules but internal to package --- */

long  Np0,Np1,Np2,Ntwo,Min,Case,Total,Range;
long  Factors[FACTORS],F,Odd_factor,Nwork;

long  factor_integer(long number)
{
long  odd_factors,quotient,divisor=2,k=0,remainder;
      quotient=number/divisor;
      remainder=number%divisor;
      while( (quotient>=divisor) && (remainder==0) )
      {
	 Ntwo*=2;
	 Factors[k++]=divisor;
	 number=quotient;
	 quotient=number/divisor;
	 remainder=number%divisor;
      }
      if (quotient<divisor)
      {
	  odd_factors=k;
	  if (remainder==0)
	  {
	      Ntwo*=2;
	      return(odd_factors);
	  }
	  else
	  {
	      Factors[k]=number;
	      return(odd_factors);
	  }
      }
/* --- no more even factors in the number --- */
      divisor=3;
      odd_factors=k;
      quotient=number/divisor;
      while( (quotient>=divisor))
      {
          remainder=number%divisor;
          if ( remainder==0)
	  {
	     Factors[k++]=divisor;
	     number=quotient;
	     quotient=number/divisor;
	  }
          else
	  {
	     divisor+=2;    /* --- look for next odd factor --- */
	     quotient=number/divisor;
	  }
      }
      Factors[k]=number;
      return(odd_factors);
}  /* --- factor_integer --- */

int   fourt(float huge *a, int *values, int dimensions, int sign, int complex)
{
long  i,j,n,dim,previous=0;
      if( dimensions<1)
	 return(-1);

      Total=2;
      for(i=0; i<dimensions; i++)
      {
	 if (values[i]<1)
	    return(-2);
	 else
	    Total*=values[i];
      }
/* --- loop over each dimension --- */
      Np1=2;
      for(dim=1; dim<=dimensions; dim++)
      {
	 n=values[dim-1];
	 Np2=Np1*n;
	 if (n>1)
	 {
/* --- is n a power of two?  what are its factors --- */
            Ntwo=Np1;
            Odd_factor=factor_integer(n);
	    Case=1; Min=0; Range=Np1;
	    if (dim<4)
	    {
	       if (complex<1)
	       {
		   Case=2;
		   Range=Np0*(1+previous/2);
		   if (dim==1)
		   {
		      Case=3;
		      Range=Np1;
		      if (Ntwo>Np1)
		      {
			 Case=4;
			 Min=1;
			 Ntwo/=2; n/=2; Np2/=2; Total/=2;
			 if (complex==0)
			 {
			   i=0;
			   for( j=0; j<Total; j++)
			   {
			      a[j]=a[i];
			      i+=2;
			   }
			 }
		      }
		   }
	       }
	    }  /* case separation */
	    /* ---- shuffle data by bit reversal for case n=2^k---- */
	    if (Ntwo>=Np2)
		n_a_power_of_2(a);
            else   /* (Ntwo<Np2) */
		n_not_power_of_2(a,n);
	    if (Ntwo>Np1)
		factors_of_2(a,sign);
	    if ( Ntwo<Np2)
            {
	       F=Odd_factor;
	       not_factors_of_2(a,sign);
	    }
/* --- complete transform using conjugate symmetry --- */
            switch (Case) {
	    case 1:  break;
	    case 2:  conj_symmetry_2nd_3rd(a,dimensions);
		     break;
	    case 3:  break;
	    case 4:  conj_symmetry_1st(a,n,sign);
		     break;
	    default: return(-3);
	    } /* switch */
	 }
	 /* else number of points==1 */
	 Np0=Np1;
	 Np1=Np2;
	 previous=n;
      }  /* loop over dimension */
}     /* fourt */

