/* --- complete a real transform in the 1st dimension
       for n an even number by conjugate symmetry
       k.t. kilty  1988 -- */
#define   TWOPI   6.28318531
#define   TRUE    1
#include  <math.h>

/* ---- elements external, but internal to  the package --- */

extern  long  Np0,Np1,Np2,Total,Range;

void   conj_symmetry_1st(float huge *a,long n,int sign)
{
long   half_n,i,j,lower,upper;
float  w_r,w_i,temp_r,temp_i,wstp_r,wstp_i,theta,dif_r,dif_i;
float  sum_r,sum_i;
       half_n=n;
       n*=2;
       theta=-TWOPI/(float)n;
       if (sign==1) theta=-theta;
       w_r=wstp_r=(float)cos((double)theta);
       w_i=wstp_i=(float)sin((double)theta);
       lower=2;
       upper=2*(half_n-1);
       while(lower<upper)
       {
	  j=upper;
	  for(i=lower; i<Total; i+=Np2)
	  {
	      sum_r=0.5*(a[i]+a[j]);
	      sum_i=0.5*(a[i+1]+a[j+1]);
	      dif_r=0.5*(a[i]-a[j]);
	      dif_i=0.5*(a[i+1]-a[j+1]);
	      temp_r=w_r*sum_i+w_i*dif_r;
	      temp_i=w_i*sum_i-w_r*dif_r;
	      a[i]=sum_r+temp_r;
	      a[i+1]=dif_i+temp_i;
	      a[j]=sum_r-temp_r;
	      a[j+1]=-dif_i+temp_i;
	      j+=Np2;
	  } /* loop over i */
	  lower+=2;
	  upper-=2;
	  temp_r=w_r;
	  w_r=w_r*wstp_r-w_i*wstp_i;
	  w_i=w_i*wstp_r+temp_r*wstp_i;
       } /* do while */
       if (lower==upper)
       {
	   if (sign==-1)
	       for(i=lower; i<Total; i+=Np2)  a[i+1]=-a[i+1];
       } /* if lower==upper */
       Np2*=2;
       Total*=2;
       j=Total-2;
       upper=Total/2;
       do  /* while i<j */
       {
          lower=upper-2*half_n;
          i=lower+2;
          while (i<upper)
          {
             a[j]=a[i];
	     a[j+1]=-a[i+1];
             i+=2; j-=2;
          } /* while(i<upper) */
          a[j]=a[lower]-a[lower+1];
          a[j+1]=0.0;
          if (i<j)
          {
	     i-=2;
	     j-=2;
	     while(i>lower)
	     {
	        a[j]=a[i];
	        a[j+1]=a[i+1];
	        j-=2;
	        i-=2;
	     } /* while i>lower */
	     a[j]=a[lower]+a[lower+1];
	     a[j+1]=0.0;
	     upper=lower;
	  } /* if i<j */
	  else
	  {
	     a[0]=a[0]+a[1];
	     a[1]=0.0;
	     return;
	  }
       } while(TRUE); /* do while from above for i>j */
} /* conj_symmetry_1st */

void   conj_symmetry_2nd_3rd(float huge *a,int dimensions)
{
long   i,j,imin,imax,jmax,s,t,smax;
       for(t=0; t<Total; t+=Np2)
       {
	   smax=t+1+Np2-Np1;
	   for(s=t; s<smax; s+=Np1)
	   {
	       imin=s+Range;
	       imax=s+Np1-1;
	       jmax=2*t+1+Np1-imin;
	       if (s>t) jmax+=Np2;
	       if (dimensions>2)
	       {
		   j=jmax+Np0;
		   for(i=imin; i<imax; i+=2)
		   {
		      a[i]=a[j];
		      a[i+1]=-a[j+1];
		      j-=2;
		   } /* loop over i */
	       } /* dimension > 2 */
	       j=jmax;
	       for(i=imin; i<imax; i+=Np0)
	       {
		  a[i]=a[j];
		  a[i+1]=-a[j+1];
		  j-=Np0;
	       } /* loop over i */
	   } /* loop over s */
       } /* loop over t */
} /* conj_symmetry_2nd_3rd */
