/*        Maximum Entropy SPECTRA         */
/*               __________               */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <math.h>

#define   PI     3.14159265
#define   FALSE  0
#define   TRUE   1

/*  ==================    F F T   ==================  */
/*                                                    */
/*          Fast  Fourier  Transform  Routine         */
/*                                                    */
/*  c_real= array containing real part of input data  */
/*  c_imag= array containing imaginary part of input  */
/*  data_length = number of values in array           */
/*  sign = transform direction  -1   on forward trans-*/
/*  form and +1 on the inverse transform.             */
/*  this algorithm requires a data length that is a   */
/*  power of two.                                     */
/*                                          k.t.kilty */
/*  ================================================  */

void fft(float huge *c_real,float huge *c_imag,int data_length,int sign)
{

float   w_real,w_imag,temp_real,temp_imag,norm,arg;
int     i,j=0,m,l,i_plus_l,banyan_step,done;

    if (sign==1) norm=1.0/(data_length);
    else         norm=1.0;
    for(i=0; i<data_length; i++)
    {
       if (j>=i)
       {
         temp_real = norm*c_real[j];
         temp_imag = norm*c_imag[j];
         c_real[j] = norm*c_real[i];
         c_imag[j] = norm*c_imag[i];
         c_real[i] = temp_real;
         c_imag[i] = temp_imag;
       }
       m = data_length/2;
       while (m>0 && j>=m)
       {
         j=j-m;
         m=m/2;
       }  /* Do While */
       j=j+m;
    }      /* Do For */
    done=FALSE;
    l=1;
    while (!done)
    {
       banyan_step=2*l;
       for(m=0; m<l; m++)
       {
          arg=(PI*m)/l;
          w_real=cos((double)arg);
          w_imag=(float)sign*sin((double)arg);
          for(i=m; i<data_length; i+=banyan_step)
	  {
             i_plus_l=i+l;
             temp_real=w_real*c_real[i_plus_l]-c_imag[i_plus_l]*w_imag;
             temp_imag=w_real*c_imag[i_plus_l]+c_real[i_plus_l]*w_imag;
             c_real[i_plus_l]=c_real[i]-temp_real;
             c_imag[i_plus_l]=c_imag[i]-temp_imag;
             c_real[i]=c_real[i]+temp_real;
             c_imag[i]=c_imag[i]+temp_imag;
          }   /* Do For */
       }     /* Do Loop */
       l=banyan_step;
       done=( (l==data_length) ? TRUE : FALSE);
    }      /* Do While */
}  /* fft */

void spin(int j)
{
gotoxy(1,1);
printf("Working on element %4i",j);
}

/*  ------------------------------------------------ */
/*            Spectral Estimation a la Burg          */
/*                                                   */
/*      This program uses levinson recursion to      */
/*    build a filter the input of which is a signal  */
/*    and the output of which is white noise.        */
/*    Thus, the filter must be the inverse spectrum. */
/*    x is a data vector, equally spaced in time,    */
/*    the length of which is data_length             */
/*    total_length > data_length controls the        */
/*    frequency resolution.                          */
/*    estimator_length < data_length is a compromise */
/*    between frequency resolution and amplitude     */
/*    scatter. The longer the estimator length the   */
/*    sharper are spectral peaks, but the more noisy */
/*    is the spectral background. I simply force the */
/*    algorithm to use an estimator no longer than   */
/*    datalength/2.                     	     */
/*    This routine requires a fast Fourier transform */
/*    Ref. The routine is a 'C' translation of one   */
/*    In Geophysical Data Analysis by John Claerbout */
/*                                                   */
/*    The function spin(int) is only to assure the   */
/*    user that the program is running. You may      */
/*    remove it without consequence.                 */
/*                                                   */
/*    K. T. Kilty     06/20/87                       */
/* ------------------------------------------------- */

int   Burg(float huge *x,int data_length,int total_length,
           int estimator_length)
{
float huge *real_s;
float huge *imag_s;
float huge *real_a;
float huge *imag_a;
float huge *real_forward;
float huge *imag_forward;
float huge *real_backward;
float huge *imag_backward;
float huge *imag_c;
float huge *real_c;
float real_temp,imag_temp;
float real_top,real_bottom,imag_top;
int   i,j,lag;

/* allocate storage  */
      real_s=(float huge *)farcalloc((unsigned)total_length,sizeof(float));
      if (real_s==NULL) return(FALSE);
      imag_s=(float huge *)farcalloc((unsigned)total_length,sizeof(float));
      if (imag_s==NULL) return(FALSE);
      real_a=(float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (real_a==NULL) return(FALSE);
      imag_a=(float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (imag_a==NULL) return(FALSE);
      real_c=(float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (real_c==NULL) return(FALSE);
      imag_c=(float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (imag_c==NULL) return(FALSE);
      real_forward= (float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (real_forward==NULL) return(FALSE);
      real_backward=(float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (real_backward==NULL) return(FALSE);
      imag_forward= (float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (imag_forward==NULL) return(FALSE);
      imag_backward=(float huge *)farcalloc((unsigned)data_length,sizeof(float));
      if (imag_backward==NULL) return(FALSE);

/* -------  Reset arrays ------------- */
     for(i=0; i<total_length; i++)
        real_s[i] = imag_s[i] = 0.0;
     real_a[0] = 1.0;
     imag_a[0] = 0.0;
     for(i=0; i<data_length; i++)
        real_forward[i] = real_backward[i] = x[i];
     for(j=1; j<=estimator_length; j++)
     {
	spin(j);
        real_top = imag_top = real_bottom = 0.0;
        for(i=j; i<data_length; i++)
	{
           lag = i-j;
           real_bottom = real_bottom + real_forward[i]*real_forward[i]
                         + real_backward[lag]*real_backward[lag];
           real_top =    real_top + real_forward[i]*real_backward[lag]
                         + imag_forward[i]*imag_backward[lag];
           imag_top =    imag_top + imag_forward[i]*real_backward[lag]
                         - real_forward[i]*imag_backward[lag];
        }
        real_c[j] = 2.0*real_top/real_bottom;
        imag_c[j] = 2.0*imag_top/real_bottom;
        for(i=j; i<data_length; i++)
	{
           lag = i-j;
           real_temp = real_forward[i];
           imag_temp = imag_forward[i];
           real_forward[i] = real_forward[i] - real_c[j]*real_backward[lag]
                            + imag_c[j]*imag_backward[lag];
           imag_forward[i] = imag_forward[i] - real_c[j]*imag_backward[lag]
                            - imag_c[j]*real_backward[lag];
           real_backward[lag] = real_backward[lag]
                            - real_c[j]*real_temp - imag_c[j]*imag_temp;
           imag_backward[lag] = imag_backward[lag]
                            + imag_c[j]*real_temp - real_c[j]*imag_temp;
        }
        real_a[j] = imag_a[j] = 0.0;
        for(i=0; i<=j; i++)
	{
           lag = j-i;
           real_s[i] = real_a[i] - real_c[j]*real_a[lag]
                       - imag_c[j]*imag_a[lag];
           imag_s[i] = imag_a[i] - imag_c[j]*real_a[lag]
                       + real_c[j]*imag_a[lag];
        }
        for(i=0;  i<=j;  i++)
	{
           real_a[i] = real_s[i];
           imag_a[i] = imag_s[i];
        }
    } /* loop over j */

/* ---------- s contains the inverse spectrum  ---------- */
    fft( real_s, imag_s, total_length,+1);
    for(i=0; i<total_length; i++)
	 x[i]=1.0/sqrt((double)(real_s[i]*real_s[i]+imag_s[i]*imag_s[i]));

    /* free allocated storage */

    farfree((void *)imag_backward);
    farfree((void *)imag_forward);
    farfree((void *)real_backward);
    farfree((void *)real_forward);
    farfree((void *)imag_c);
    farfree((void *)real_c);
    farfree((void *)imag_a);
    farfree((void *)real_a);
    farfree((void *)imag_s);
    farfree((void *)real_s);
    return(TRUE);
}   /*  FFT  */

float parseimage(char *s)
{
/* If there are two data items on a line then the second is the */
/* time series. If there is only one on a line, it must be the  */
/* time series/ */
int i=0,j=0,element=0,readingnumber=FALSE;
float x[3];    /* one extra in case */
char buf[31];
while (element<2)
{
   switch (*(s+i)) {
   case '0':
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
   case '+':
   case 'e':
   case '-':
   case '.':
      readingnumber=TRUE;
      buf[j]=*(s+i);
      j++;
      break;
   case ' ':
   case ',':
   if (readingnumber)
   {
      buf[j]=(char)0;
      x[element]=atof(buf);
      element++;
      readingnumber=FALSE;
      j=0;
   }
   break;
   case '\n':
   if (readingnumber)
   {
      buf[j]=(char)0;
      x[element]=atof(buf);
      element++;
      readingnumber=FALSE;
      j=0;
   }
   if (element>0) return(x[element-1]);
   else return(0.0);
   default: break;
   } /* end switch */
     i++;
}
/* oops! found a third element */
return(x[1]);
}

int isapowerof2(int i)
{
unsigned int test=2;
while (test<32768)
{
   if (i==test) return(TRUE);
   test*=2;
}
return(FALSE);
}

main(int argc, char **argv)
{
FILE *infile,*outfile;
char str[81];
float huge *spectrum;
float huge *series;
int i,j,out;
int datalength,totallength,estimator;
/* process command line */
/* open input file */
    if (argc<5)  /* not enough  arguments in command line */
    {
       printf("Error. Not enough parameters passed to routine.\n");
       printf("Use this program by typing the command line:\n\n");
       printf("BURG INPUT OUTPUT DATALENGTH TOTALLENGTH ESTIMATOR\n\n");
       printf("Where BURG is the name of this program.\n");
       printf("INPUT is the name of a file which contains\n");
       printf("a series (x,y) or (t,y) in %%f %%f, or\n");
       printf("just y in %%f format.\n");
       printf("OUTPUT is the name of a file to contain the\n");
       printf("processed spectrum. DATALENGTH is the number of\n");
       printf("elements in the input series. TOTALLENGTH is the\n");
       printf("number of elements in the output spectrum, and\n");
       printf("is a power of 2 and greater than DATALENGTH. ESTIMATOR\n");
       printf("is the length of the prediction filter. It must be less\n");
       printf("than DATALENGTH/2. A larger value of ESTIMATOR produces\n");
       printf("sharper spectral peaks, but a noisier spectral background.\n");
       exit(1);
    }
    else if ((infile=fopen(*++argv, "r")) == NULL)
    {
       printf("Input file not found.\n");
       exit(1);
    }
    if ((outfile=fopen(*++argv, "r")) == NULL)
       outfile=fopen(*argv,"w");
    else
    {
       printf("Destination file %s already exists.\n",*argv);
       printf("Shall I overwrite it (y/n)?");
       out=toupper(bioskey(0));
       if (out=='Y')
       {
	  printf(" Yes\n");
	  outfile=fopen(*argv,"w");
       }
       else
       {
	  printf(" No\n");
	  exit(1);
       }
    }
    if (*++argv != NULL)
       datalength=atoi(*argv);
    else
    {
       printf("There are no integer values provided.\n\n");
       exit(1);
    }
    if (*++argv != NULL)
       totallength=atoi(*argv);
    else
    {
       printf("There is no total or estimator length provided.\n\n");
       exit(1);
    }
    if (*++argv != NULL)
       estimator=atoi(*argv);
    else
    {
       printf("There is no estimator length provided.\n\n");
       exit(1);
    }
/* make quick checks of consistency of values provided. */
if (datalength>totallength)
{
   printf("Total length is not as long as data length.\n");
   exit(1);
}
else if (estimator>datalength/2)
{
   printf("Estimator is too long.\n");
   exit(1);
}
else if (!isapowerof2(totallength))
{
   printf("Total length has to be a power of two.\n");
   exit(1);
}
/* get memory for data */
spectrum = series = (float huge *)farcalloc( totallength, sizeof(float));
if (spectrum==NULL)
{
   printf("Insufficient memory to allocate storage for total length.\n");
   exit(1);
}
/* read and parse data */

i=0;
while ( (fgets( str, 80, infile)!=NULL) && (i<datalength) )
{
 series[i] = parseimage(str);
 i++;
}  /* READING WHILE LOOP */
/* is i less than datalength? if so make adjustments*/
if (i<datalength)
{
   datalength=i;
   estimator=min(estimator,datalength/2);
}

if (Burg(series,datalength,totallength,estimator)==FALSE)
{
   printf("Insufficient memory to allocate workspace in Burg function.\n");
   exit(1);
}


for(i=0; i<datalength; i++)
   fprintf(outfile,"%6i %10.3f\n",i, spectrum[i]);


} /* end main */