/*                     SORT                      */
/*

       This routine reads a file of x,y,z values,
       determines which node in a grid each data
       item is closest, and writes that data item
       into three arrays.

            X = an array of x coordinates of all
                data items.
            Y = an array of y coordinates of all
                data items.
            Z = an array of the ordinate data.

        The sorting may find that more than one
        data value is within a given grid element.
        In this case the program may be configured
        to do one of two things.  It may take only
        the closest value to a node, or it may form
        the average value of all the data.  The function
        returns the number of data values.  The average
        value is used in the call to set_val only.

                               K. T. Kilty
			       Wheatridge, Colorado
                               October 1987
*/

#include "minq.h"
#include <alloc.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

void writef(int col,int row,char *string)
{
    gotoxy(col,row);
    printf("%s",string);
}

float  search(int *control,float huge *data,int col,int row,
		 int l,int n,int m,int maxsearch,float average)
{
int pointer,i,j,row1,col1,distance=1,values = 0;
float radius,old_radius,nearest_value;
nearest_value = 0.0;
while(!values)
{
   old_radius = 3 * distance * distance;
   for(j=-distance; j<=distance; j+=distance)
   {
      row1=row+j*l;
      if( (row1>-1) && (row1<m))
      {
	 for(i=-distance; i<=distance; i+=distance)
	 {
	    col1=col+i*l;
	    if ((col1>-1) && (col1<n))
	    {
	       pointer=row1*n+col1;
	       if(control[pointer]!=0)
	       {
		  radius=i*i+j*j;
		  if (radius==old_radius)
		  {
		     nearest_value+=data[pointer];
		     values++;
		  }
		  if (radius<old_radius)
		  {
		     nearest_value=data[pointer];
		     old_radius=radius;
		     values=1;
		  }
	       } /* if control */
	    }   /* if columns within bounds  */
	 }      /* i loop */
      }         /* if rows are within bounds */
   }            /* j loop */
   distance++;
   if (distance>maxsearch) break; /* end the loop of the search distance is too large */
} /* while searching for a ring with values in it. */
if(values)
   return(nearest_value/values);
else
   return(average);
}/* search */

void set_val(float huge *u, int *control, float average, GRIDDEF minq)
{
int i,row,column,maxsearch;
maxsearch = min( minq.m_actual/2, minq.n_actual/2);
   for(row=0; row<minq.m_actual; row+=minq.ll)
   {
      for(column=0; column<minq.n_actual; column+=minq.ll)
      {
	 i = row*minq.n_actual + column;
	 if (control[i]==0)
	    u[i] = search(control,u,column,row,minq.ll,
			  minq.n_actual,minq.m_actual,maxsearch,average);
      }
   }
} /* set_val */

int sort( float huge *x, float huge *y, float huge *z, float huge *u,
			 int *control,	GRIDDEF minq )
{
int    nodes,i,status,index,row,column;
float  distance_new,distance_old,xx,yy,zz;
float  average;
/*        make certain the permanent arrays have all
          zero values in empty spots. */
i=0;
nodes = minq.n_actual * minq.m_actual;
while (fscanf(minq.datafp,"%f %f %f\n",&xx,&yy,&zz)==3)
{
   xx = (xx-minq.x_grid_min)/minq.x_increment;  /* xx and yy are shifted */
   yy = (yy-minq.y_grid_min)/minq.y_increment;  /* and scaled to grid. */
   column = floor( xx + 0.5);
   row = floor( yy + 0.5);
   if ((row>=0 && row<minq.m_actual) && (column>=0 && column<minq.n_actual))
   {
      index = row*minq.n_actual + column;
      distance_new = xx*xx+yy*yy;
      if ( minq.option=='C')
      {
	 if ( control[index]==0)    /*  no data in grid element yet */
	 {
	    z[index] = zz;
	    x[index] = xx;
	    y[index] = yy;
	    control[index]=1;
	 }
	 else                       /* there is data within element */
	 {
	    distance_old = x[index]*x[index]+y[index]*y[index];
	    if (distance_new<distance_old)
	    {
	       z[index] = zz;
	       x[index] = xx;
	       y[index] = yy;
	    }
	 }
      }
      else     /*  option='A'   */
      {
	 z[index] = z[index] + zz;
	 x[index] = x[index] + xx;
	 y[index] = y[index] + yy;
	 control[index]++;
      }
   }
}   /*  while */
/*  now we have read the data -- determine the value of the
    control vector and use it to normalize if option=0  otherwise
    simply move data back to next available element.  */
i = index = 0;
average=0.0;
do
{
   if ( minq.option=='C' )
   {
      if ( control[i] != 0)
      {
	 u[i]=z[i];
	 z[index]=z[i];
	 x[index]=x[i];
	 y[index]=y[i];
	 average=average+z[index];
	 index++;
      }
   }
   else                  /* option=0 */
   {
      if ( control[i] != 0)
      {
	 x[index] = x[i]/control[i];
	 y[index] = y[i]/control[i];
	 z[index] = z[i]/control[i];
	 u[i]=z[index];
	 average=average+z[index];
	 index++;
      }
   }
   i++;
} while ( i < nodes);
average=average/index;
set_val( u, control, average, minq );
fclose(minq.datafp);
return(index);
}/* sort */

void find_limits(float huge *u, int nodes, float *z_min, float *z_max)
{
int i;
   *z_min = u[0];
   *z_max = u[0];
   for(i=1; i<nodes; i++)
   {
      if (*z_min > u[i] ) *z_min = u[i];
      if (*z_max < u[i] ) *z_max = u[i];
   }
}    /* find_limits */

void wrt_grd( float huge *u, GRIDDEF minq )
{
int m,n,row,column,ix,nodes;
float z_min,z_max;
nodes=minq.ncols_in_grid*minq.nrows_in_grid;
find_limits(u, nodes, &z_min, &z_max);
fprintf(minq.gridfp,"%d %d\n",minq.ncols_in_grid,minq.nrows_in_grid);
fprintf(minq.gridfp,"%f %f\n",minq.x_grid_min,minq.x_grid_max);
fprintf(minq.gridfp,"%f %f\n",minq.y_grid_min,minq.y_grid_max);
fprintf(minq.gridfp,"%f %f\n",z_min,z_max);
for(row=0; row<minq.nrows_in_grid; row++)
{
   for(column=0; column<minq.ncols_in_grid; column++)
   {
      ix = row * minq.ncols_in_grid + column;
      fprintf(minq.gridfp,"%f ",u[ix]);
   }
   fprintf(minq.gridfp,"\n");
}
fclose(minq.gridfp);
} /*  wrt_grid  */

void pack_grd( float huge *u, GRIDDEF minq )
{
int  i,j,bias_in,bias_out;
   if (minq.n_actual==minq.ncols_in_grid
       && minq.m_actual==minq.nrows_in_grid) return;
   for(j=0; j< minq.nrows_in_grid; j++)
   {
      bias_in = j * minq.n_actual;
      bias_out = j * minq.ncols_in_grid;
      for(i=0; i< minq.nrows_in_grid; i++)
	 u[bias_out++] = u[bias_in++];
   }
}  /*  pack_grid */

void MinQ( GRIDDEF minq )
{
float huge*x,huge*y,huge*z,huge*u;
int i,l,m,n,status,*control;
/*
  set m_actual and n_actual according to what the user has
  requested subject to the need for m,n to be odd.
*/
   minq.x_increment =(minq.x_grid_max-minq.x_grid_min)/(minq.ncols_in_grid-1);
   minq.y_increment =(minq.y_grid_max-minq.y_grid_min)/(minq.nrows_in_grid-1);
   if ((minq.nrows_in_grid % 2)==0)
   {
      minq.m_actual = minq.nrows_in_grid + 1;
      minq.y_grid_max += minq.y_increment;
   }
   else minq.m_actual = minq.nrows_in_grid;
   if ((minq.ncols_in_grid % 2)==0)
   {
      minq.n_actual = minq.ncols_in_grid + 1;
      minq.x_grid_max += minq.x_increment;
   }
   else minq.n_actual = minq.ncols_in_grid;
/* ---------------- oOo --------------- */
   minq.vector_size = minq.m_actual * minq.n_actual;
   control=(int *)calloc(minq.vector_size, sizeof(int) );
   x=(float huge *)farcalloc(minq.vector_size,(unsigned long)sizeof(float) );
   y=(float huge *)farcalloc(minq.vector_size,(unsigned long)sizeof(float) );
   z=(float huge *)farcalloc(minq.vector_size,(unsigned long)sizeof(float) );
   u=(float huge *)farcalloc(minq.vector_size,(unsigned long)sizeof(float) );
   if (u==NULL) exit(3);
   /*======= initialize   vectors  ====================*/
   for(i=0; i<minq.vector_size; i++)
   {
      x[i]=y[i]=z[i]=u[i]=0.0;
      control[i]=0;
   }
/*  ----- set L value ---- */
   m=minq.m_actual-1;
   n=minq.n_actual-1;
   l=1;
   while (m%2==0 && n%2==0 && m>4 && n>4)
   { l*=2; m/=2; n/=2; }
   minq.ll=l;
/* ---------------- grid the data ------------------ */
   if (minq.dbug) writef(1,1,"reading data file");
   minq.no_of_data = sort(x,y,z,u,control,minq);
   if (minq.dbug) writef(1,1,"iterating ...");
   status=grid(x,y,z,u,control,minq);
   if  (status)
   {
      if (minq.dbug) writef(1,1,"writing grid file");
      if ((minq.nrows_in_grid % 2)==0)
	 minq.y_grid_max -= minq.y_increment;
      if ((minq.ncols_in_grid % 2)==0)
	 minq.x_grid_max -= minq.x_increment;
      minq.vector_size = minq.m_actual * minq.n_actual;
      pack_grd(u,minq);
      wrt_grd(u,minq);
   }
}    /*   MinQ    */

int isword(char *command,char *target)
{
char *p;
   if(strstr(command,target)!=NULL)
   {
      p=strchr(command,'\n');
      if (p!=NULL) *p=0;
      p=strchr(command,'=');
      if (p!=NULL)
	strcpy(command,p+1);
      return(TRUE);
   }
   else return(FALSE);
}

GRIDDEF readjob(FILE *job)
{
GRIDDEF m;
char s[81],*p;
while ( fgets( s, 80, job)!=NULL)
{
   if (isword(s,"nrows")) m.m_requested=m.nrows_in_grid=atoi(s);
   else if (isword(s,"ncols")) m.n_requested=m.ncols_in_grid=atoi(s);
   else if (isword(s,"xmin")) m.x_grid_min=atof(s);
   else if (isword(s,"xmax")) m.x_grid_max=atof(s);
   else if (isword(s,"ymin")) m.y_grid_min=atof(s);
   else if (isword(s,"ymax")) m.y_grid_max=atof(s);
   else if (isword(s,"delta")) m.delta_z=atof(s);
   else if (isword(s,"maxit")) m.max_iterations=atoi(s);
   else if (isword(s,"option")) m.option=*s;
   else if (isword(s,"data"))
   { if ((m.datafp=fopen(s,"r"))==NULL) exit(7); }
   else if (isword(s,"grid")) m.gridfp=fopen(s,"w");
   else if (isword(s,"header"))
   {
      if (m.gridfp!=NULL) fprintf(m.gridfp,"header\n");
      p=fgets(s,80,job);
      while (p!=NULL && !isword(s,"end header"))
      {
	 if (m.gridfp!=NULL) fprintf(m.gridfp,"%s",s);
	 p=fgets(s,80,job);
      }
      if (m.gridfp!=NULL) fprintf(m.gridfp,"end header\n");
   }
}
return(m);
}

main(int argc,char **argv)
{
/*
      Terminate Job on any of the following:
      exit 1 - no command line parameters.
      exit 2 - can't open job file.
      exit 3 - not enough memory in heap.
      exit 4 - either m or n less than 5.
      exit 5 - more data than room to store.
      exit 6 - L value is incorrect.
      exit 7 - can't open data file.
*/
GRIDDEF minq;
FILE *job;
if (argc>1)
{
   job=fopen(*++argv,"r");
   if (job!=NULL)
      minq=readjob(job);
   else
      exit(2);
   if (argc>2) minq.dbug=TRUE; else minq.dbug=FALSE;
   MinQ( minq);
}
else exit(1);
}
