#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cm.h"

#define ON_MAP x<=cm.x_grid_maximum && x>=cm.x_grid_minimum && y<=cm.y_grid_maximum && y>=cm.y_grid_minimum

/* global variables */
char currentstyle='X';
float *ci,*cj;
float xScale, yScale;
float xwmax, ywmax;
float xwmin, ywmin;
float xwrange, ywrange;
float horizontal_length, vertical_length;
float x_origin=0.0, y_origin=0.0;
char * symbol_buffer;
float xlolim = 0.0;
float ylolim = 0.0;
float xrange = 0.0;
float yrange = 0.0;
int indexed, cindex, pen, number_of_extrema;
float cval;
int *xbits, xbits_size;
int x_labl_freq, y_labl_freq;
float x_tick_dist, y_tick_dist;
float y_units_per_inch,x_units_per_inch;
int axis_labl_dec_digits;
float x_grids, y_grids;
char axis_labl_format;
int wsize = 16;
int n_line_segments=200;
float undefv=0x00ffffff;
float *contourp, cval;
float adjust, adjus2;
char *ascii[128];
float axis_labl_height,tickmark_length,grid_dash_length;
int axis_labl_color,grid_color;
int file_loaded;


EXTREMUM *extrema=NULL;
CONTOURDEF Cm;

/* key words for definition file */
char *Words[] = {
"first row",                       /* 0 */
"last row",                        /* 1 */
"first column",                    /* 2 */
"last column",                     /* 3 */
"grid file",                       /* 4 */
"minimum contour",                 /* 5 */
"maximum contour",                 /* 6 */
"contour interval",                /* 7 */
"level file",                      /* 8 */
"label freq",                      /* 9 */
"contour color",                   /* 10 */
"contour thickness",               /* 11 */
"label style",                     /* 12 */
"unlabel color",                   /* 13 */
"unlabel thickness",               /* 14 */
"unlabel style",                   /* 15 */
"grid subinterval",                /* 16 */
"center type",                     /* 17 */
"center height",                   /* 18 */
"hachure length",                  /* 19 */
"hachure suppression",             /* 20 */
"hachure separation",              /* 21 */
"pole suppression",                /* 22 */
"contour suppression",             /* 23 */
"inline label color",              /* 24 */
"inline label format",             /* 25 */
"inline decimal digits",           /* 26 */
"inline height",                   /* 27 */
"inline tension",                  /* 28 */
"post file",                       /* 29 */
"symbol angle",                    /* 30 */
"symbol height",                   /* 31 */
"symbol color",                    /* 32 */
"post label format",               /* 33 */
"post digits",                     /* 34 */
"post angle",                      /* 35 */
"post height",                     /* 36 */
"post color",                      /* 37 */
"plot file",                       /* 38 */
"plot scale",                      /* 39 */
"header",                          /* 40 */
NULL};

void setgrd(float lolimx, float lolimy, float hilimx, float hilimy)
{
xlolim = lolimx;
xrange=hilimx-xlolim;
ylolim=lolimy;
yrange=hilimy-ylolim;
return;
}

void postpoints(CONTOURDEF cm)
{
char out[20], fmt[20];
float x,y,z,u,v;
if(cm.postfp==NULL) return;
if(cm.post_height>0.0)
{
sp(cm.post_color);
setsymbols("CENTERED.SYM");
sprintf(out,"%c\0",41);
while(fscanf(cm.postfp,"%f %f %f\n",&x,&y,&z)==3)
{
   if(ON_MAP)
     ps(wxcoordo(x), wycoordo(y), cm.post_height, cm.post_angle, out);
}
rewind(cm.postfp);
}
setsymbols("DEFAULT.SYM");
if(cm.post_labl_height>0.0)
{
   sprintf(fmt,"%%.%d%c",cm.post_dec_digits,cm.post_labl_format);
   while(fscanf(cm.postfp,"%f %f %f\n",&x,&y,&z)==3)
   {
     if(ON_MAP)
     {
	sprintf(out, fmt, z);
	u=wxcoordo(x)+cm.post_labl_height*cos(0.01745*cm.post_labl_angle);
	v=wycoordo(y)+cm.post_labl_height*sin(0.01745*cm.post_labl_angle);
	ps(u,v,cm.post_labl_height, cm.post_labl_angle, out);
     }
   }
}
fclose(cm.postfp);
return;
}

void writef(int col,int row,char *string)
{
    gotoxy(col,row);
    printf("%s",string);
}

void ContouR(CONTOURDEF cm)
{
char fmt[50];
int i,j;
Cm=cm;               /* move the job structure to global for easier use */
read_grid_file();
if (Cm.levelfp!=NULL)
   read_contour_levels();
else
   calculate_contour_levels();
xScale = yScale = Cm.pscale;
xwmin = Cm.x_grid_minimum;
ywmin = Cm.y_grid_minimum;
xwmax = Cm.x_grid_maximum;
ywmax = Cm.y_grid_maximum;
ywrange = ywmax - ywmin;
xwrange = xwmax - xwmin;
horizontal_length = xwrange/xScale;
vertical_length = ywrange/yScale;
scale_length_adj();
if (!Cm.output)
{
   fprintf( Cm.plotfp,"SC %f %f\n",1.0,1.0);
   fprintf( Cm.plotfp,"TR %f %f\n",x_origin,y_origin);
}
else ss('S');
setgrd ( x_origin, y_origin,
	 x_origin+horizontal_length, y_origin+vertical_length);
setsymbols("DEFAULT.SYM");
if(Cm.postfp!=NULL)
{
   if (Cm.dbug) writef(27,12,"Posting points and values.");
   postpoints(cm);
}
if(Cm.center_labl_height!=0.0 || Cm.hachure_len!=0.0)
{
   resolve_extrema(FALSE);
   if(number_of_extrema>0)
   {
     extrema=(EXTREMUM *)calloc( number_of_extrema, sizeof(EXTREMUM) );
     resolve_extrema(TRUE);
   }
}
for (i=0; i<Cm.n_cvals; i++)
{
   cval = Cm.contour[i];
   sprintf(fmt,"Plotting contour level %9.2f",cval);
   if (Cm.dbug) writef(24,12,fmt);
   cindex=i;
   indexed=FALSE;
   if(Cm.labl_line_frequency!=0)
     indexed = (i%Cm.labl_line_frequency)?FALSE:TRUE;
   for(j=0; j<xbits_size; j++) xbits[j]=0;
   start();
   if(Cm.dbug && kbhit()!=0) break;
}
if (Cm.dbug) writef( 32,10,"Finished");
fclose(Cm.plotfp);
}

int isword(char *command,char **list)
{
char *p;
int i=0;
   while(list[i]!=NULL)
   {
      if ( strstr(command,list[i])!=NULL)
      {
	 p=strchr(command,'\n');
	 if (p!=NULL) *p=0;
	 p=strchr(command,'=');
	 if (p!=NULL)
	   strcpy(command,p+1);
	 return(i);
      }
      i++;
   }
   return(NIL);
}

CONTOURDEF zero_struct(void)
{
CONTOURDEF cm;
cm.dbug=0;
cm.output=1;  /* TRUE value means that stroked font output is default */
cm.data=NULL;
cm.plotfp=NULL;
cm.gridfp=NULL;
cm.postfp=NULL;
cm.levelfp=NULL;
cm.ncols_in_grid=0;
cm.nrows_in_grid=0;
cm.first_row=0;
cm.last_row=0;
cm.first_column=0;
cm.last_column=0;
cm.pscale=1.0;
cm.x_grid_minimum=0.0;
cm.x_grid_maximum=0.0;
cm.y_grid_minimum=0.0;
cm.y_grid_maximum=0.0;
cm.x_incr=0.0;
cm.y_incr=0.0;
cm.z_minimum=0.0;
cm.z_maximum=0.0;
cm.minimum_contour=0.0;
cm.maximum_contour=0.0;
cm.contour_interval=1.0;
cm.contour=NULL;
cm.n_cvals=0;
cm.center_labl_height=0.0;
cm.center_labl_style='\0';
cm.hachure_len=0.0;
cm.hachure_sep=0.1;
cm.hachure_sup=1.01;
cm.poles=5;
cm.grid_interval=2;
cm.labl_line_frequency=1;
cm.labl_line_color=0;
cm.labl_thickness=0.0;
cm.labl_style='S';
cm.unlabl_line_color=0;
cm.unlabl_thickness=0.0;
cm.unlabl_style='S';
cm.contour_sup=1.01;
cm.con_labl_format='f';
cm.con_labl_dec_digits=0;
cm.con_labl_height=0.0;
cm.con_labl_color=0;
cm.con_labl_tension=1.01;
cm.post_angle=0.0;
cm.post_height=0.0;
cm.post_color=0;
cm.post_labl_format='f';
cm.post_dec_digits=0;
cm.post_labl_angle=0.0;
cm.post_labl_height=0.0;
cm.post_labl_color=0;
cm.vector_size=0;
return(cm);
}

CONTOURDEF readjob(FILE *job)
{
CONTOURDEF cm;
char s[81],*p;
cm=zero_struct();
while( fgets(s,80,job)!=NULL)
{
   switch ( isword(s,Words)) {
     case NIL : break;
     case 0: /*first row*/
	cm.first_row=atoi(s);
	break;
     case 1: /*last row*/
	cm.last_row=atoi(s);
	break;
     case 2: /*first column*/
	cm.first_column=atoi(s);
	break;
     case 3: /*last column*/
	cm.last_column=atoi(s);
	break;
     case 4: /*grid*/
	if ((cm.gridfp=fopen(s,"r"))==NULL)
	  exit(4);
	break;
     case 5: /*minimum contour*/
	cm.minimum_contour=atof(s);
	break;
     case 6: /*maximum contour*/
	cm.maximum_contour=atof(s);
	break;
     case 7: /*contour interval*/
	cm.contour_interval=atof(s);
	break;
     case 8: /*level file*/
	if ((cm.levelfp=fopen(s,"r"))==NULL)
	   exit(6);
	break;
     case 9: /*label freq*/
	cm.labl_line_frequency=atoi(s);
	break;
     case 10: /*label color*/
	cm.labl_line_color=atoi(s);
	break;
     case 11: /*label thickness*/
	cm.labl_thickness=atof(s);
	break;
     case 12: /*label style*/
	cm.labl_style=toupper(*s);
	break;
     case 13: /*unlabel color*/
	cm.unlabl_line_color=atoi(s);
	break;
     case 14: /*unlabel thickness*/
	cm.unlabl_thickness=atof(s);
	break;
     case 15: /*unlabel style*/
	cm.unlabl_style=toupper(*s);
	break;
     case 16: /*grid subinterval*/
	cm.grid_interval=atoi(s);
	break;
     case 17: /*center type*/
	cm.center_labl_style=toupper(*s);
	break;
     case 18: /*center height*/
	cm.center_labl_height=atof(s);
	break;
     case 19: /*hachure length*/
	cm.hachure_len=atof(s);
	break;
     case 20: /*hachure suppression*/
	cm.hachure_sup=atof(s);
	break;
     case 21: /*hachure separation*/
	cm.hachure_sep=atof(s);
	break;
     case 22: /*pole suppression*/
	cm.poles=atoi(s);
	break;
     case 23: /*contour suppression*/
	cm.contour_sup=atoi(s);
	break;
     case 24: /*inline label color*/
	cm.con_labl_color=atoi(s);
	break;
     case 25: /*inline label format*/
	cm.con_labl_format=tolower(*s);
	break;
     case 26: /*inline decimal digits */
	cm.con_labl_dec_digits=atoi(s);
	break;
     case 27: /*inline height*/
	cm.con_labl_height=atof(s);
	break;
     case 28: /*inline tension*/
	cm.con_labl_tension=atof(s);
	break;
     case 29: /*post file*/
	if ((cm.postfp=fopen(s,"r"))==NULL)
	   exit(5);
	break;
     case 30: /*symbol angle*/
	cm.post_angle=atof(s);
	break;
     case 31: /*symbol height*/
	cm.post_height=atof(s);
	break;
     case 32: /*symbol color*/
	cm.post_color=atoi(s);
	break;
     case 33: /*post label format*/
	cm.post_labl_format=tolower(*s);
	break;
     case 34: /*post digits*/
	cm.post_dec_digits=atoi(s);
	break;
     case 35: /*post angle*/
	cm.post_labl_angle=atof(s);
	break;
     case 36: /*post height*/
	cm.post_labl_height=atof(s);
	break;
     case 37: /*post color*/
	cm.post_labl_color=atoi(s);
	break;
     case 38: /*plot file*/
	cm.plotfp=fopen(s,"w");
	break;
     case 39: /*plot scale */
	cm.pscale=atof(s);
	break;
     case 40: /*header begin*/
      {
	 if (cm.plotfp!=NULL) fprintf(cm.plotfp,"header\n");
	 p=fgets(s,80,job);
	 while (p!=NULL && strstr(s,"end header")==NULL)
	 {
	     if (cm.plotfp!=NULL) fprintf(cm.plotfp,"%s",s);
	     p=fgets(s,80,job);
	 }
	 if (cm.plotfp!=NULL) fprintf(cm.plotfp,"end header\n");
      }
      break;
}  /* switch */
} /* end while */
return(cm);
}

main(int argc,char **argv)
{
/*
      Terminate Job on any of the following:
      exit 1 - no command line parameters.
      exit 2 - can't open job file.
      exit 3 - not enough memory in far heap.
      exit 4 - can't open grid file.
      exit 5 - can't open post file.
      exit 6 - can't open level file.
      exit 7 - abnormal termination kover<0.
      exit 8 - abnormal termination.
      exit 9 - not enough memory in near heap.
      exit 10- Too many contours.
*/
CONTOURDEF cm;
FILE *job;
if (argc>1)
{
   job=fopen(*++argv,"r");
   if (job!=NULL)
      cm=readjob(job);
   else
      exit(2);
   if (argc>2)
   {
      argv++;
      if ( strchr(*argv,'S')!=NULL )
	cm.output=TRUE; else cm.output=FALSE;
      if ( strchr(*argv,'D')!=NULL)
	cm.dbug=TRUE; else cm.dbug=FALSE;
   }
   else cm.dbug=FALSE;
   ContouR(cm);
}
else exit(1);
}
